IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CFJ_Producto_Valida_Stock') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CFJ_Producto_Valida_Stock
END
GO

CREATE FUNCTION [dbo].[CFJ_Producto_Valida_Stock] (@pJson VARCHAR(8000))
RETURNS SMALLINT
AS
BEGIN
/*
 * LOG VERSIONES:
 * 07/12/2023: Se agrego Log de Versiones
 * Retorno: -1 = Producto sin stock | 0 = Producto NO valida Stock | >= 1 = Producto valida Stock (Cantidad) 
*/

/*Declaracion Variables Json*/
DECLARE @pId_Producto			VARCHAR(14)

SET @pId_Producto				= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), '')
/*Fin Declaracion Variables Json*/

/*Declaracion Variables Locales*/
DECLARE @ReturnValue	INT
DECLARE @Valida			SMALLINT
DECLARE @Cantidad		INT
/*Fin de Declaraciones Variables Locales*/

	SET @ReturnValue = 0

	SET @Valida = ISNULL((SELECT 1 FROM Productos 
							WHERE Estiba_Max > 0
							AND Maneja_Stock = 1
							AND Fraciona_Stk = 1
							AND Id_Producto = @pId_Producto), 0)

IF (@Valida >= 1 AND dbo.CF_xParam('Validar_Stk_Factura') = 1)
BEGIN

	SET @Cantidad =  ISNULL((SELECT SUM(isnull(I.Cantidad,0) * T.Compromete_Stock)
							 FROM Cbtes_Items I, Cbtes C, Cbtes_Tipos T 
							 WHERE I.Id_Trans = C.Id_Trans 
							 AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte 
							 AND C.Id_Estado_Cbte not in (0,3) 
							 AND I.Id_Estado_Cbte <> DBO.CF_xParam('EST_INIC_ITEMS_VMAT')
							 AND I.Flag_QA <> 'X'
							 AND T.Compromete_Stock in (1,-1) 
							 AND (I.Fecha_QA < dateadd(day,1,Fecha) OR I.Fecha_QA IS NULL )
							 AND I.Id_Producto = @pId_Producto), 0)

	IF (@Cantidad <= 0)
	BEGIN
		SET @ReturnValue = -1
	END
	ELSE
	BEGIN
		SET @ReturnValue = @Cantidad
	END
END


RETURN ISNULL(@ReturnValue, 0)
END